{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitEspectroscopi;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, UnitDadesGlobus2, MMSystem, StdCtrls, UnitMatematiques;

type
  TFormEspectroscopi = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    EditUnitatX: TEdit;
    EditUnitatY: TEdit;
    SpeedButtonEngegarPararGlobus: TSpeedButton;
    CheckBoxLiniesAlMateixLLoc: TCheckBox;
    CheckBoxOsciloscopi: TCheckBox;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    CheckBoxEnvolvent: TCheckBox;
    CheckBoxFFT: TCheckBox;
    CheckBoxMagic: TCheckBox;
    Panel1: TPanel;
    LabelFrequencia: TLabel;
    LabelTornatNota: TLabel;
    LabelDecibels: TLabel;
    CheckBoxCalculAutomaticFrequencia: TCheckBox;
    CheckBoxRapid: TCheckBox;
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure EditUnitatXExit(Sender: TObject);
    procedure EditUnitatYExit(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButtonEngegarPararGlobusClick(Sender: TObject);
    procedure CheckBoxLiniesAlMateixLLocClick(Sender: TObject);
    procedure CheckBoxOsciloscopiClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
    procedure CheckBoxFFTClick(Sender: TObject);
    procedure CheckBoxEnvolventClick(Sender: TObject);
    procedure CheckBoxMagicClick(Sender: TObject);
    procedure PanelMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure CheckBoxCalculAutomaticFrequenciaClick(Sender: TObject);
    procedure Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure CheckBoxRapidClick(Sender: TObject);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    UnitatEixX:LongInt;
    UnitatEixY:Single;
    NombreDEspectres:integer;
    XMinim:Integer;
    EnergiaOna:Real;
    UltimN:Integer;
    LiniesEspectroscopi: array[0..1,1..BytesBufferMaxim] of Integer;
    LiniesOsciloscopi: array[0..1,1..BytesBufferMaxim] of Integer;
    ComensamentOsciloscopi: array[0..1] of integer;
    Envolvent:SoReal;
    LiniesEnvolvent: array[0..1,1..BytesBufferMaxim] of Integer;
    LiniaProfe:integer;
    AlturaInicial:integer;
    procedure Pintar;
    procedure IniciarCaptions;
  end;

var
  FormEspectroscopi: TFormEspectroscopi;

{************************************************}
IMPLEMENTATION
{************************************************}

Uses UnitEntradaSo, UnitCalculFFT, UnitTools;

{$R *.DFM}

procedure TFormEspectroscopi.FormCreate(Sender: TObject);
var
  i:integer;
begin
  UnitatEixX:=1000;
  //UnitatEixY:=4;
  UnitatEixY:=StrToInt(EditUnitatY.Text);
  for i:=1 to BytesBufferMaxim do begin
    LiniesEspectroscopi[0,i]:=0;
    LiniesEspectroscopi[1,i]:=0;
    LiniesOsciloscopi[0,i]:=128;
    LiniesOsciloscopi[1,i]:=128;
    Envolvent[i]:=0;
    LiniesEnvolvent[0,i]:=0;
    LiniesEnvolvent[1,i]:=0;
  end;
  ComensamentOsciloscopi[0]:=1;
  ComensamentOsciloscopi[1]:=1;
  LiniaProfe:=-1;
  AlturaInicial:=ClientHeight-Panel.Height-80;
  CheckBoxLiniesAlMateixLLocClick(Sender);
  XMinim:=10;
  UltimN:=200;
end;

procedure TFormEspectroscopi.Pintar;
var
  i,n:integer;
  inci:Single;
  Sota:integer;
  StrFrec:string;
  Escala:single;
var
  k,Comodi:integer;
  SumaDesfase:LongInt;
  ValorsSumaDesfase: array[0..512] of Byte;
  Maxim,Minim,XMaxim:integer;
  XLiniaMax,YLiniaMax:integer;
begin
  Escala:=40;
  EnergiaOna:=0;
  if BytesBuffer>0 then begin
    for i:=1 to BytesBuffer do EnergiaOna:=EnergiaOna+sqr(so[NumeroBufer,i]-128);
    EnergiaOna:=EnergiaOna/BytesBuffer;
    if (EnergiaOna>0) and (EnergiaOna<sqr(128)) then begin
      EnergiaOna:=10*ln(EnergiaOna/sqr(128))/ln(10);
      LabelDecibels.Font.Color:=RGB(128,128,0);
      LabelDecibels.Caption:=FloatToStr(Round(EnergiaOna*100/100))+' Db.';
    end;
  end;
  if liniaProfe=0 then begin
    for i:=1 to NombreDEspectres do LiniesEspectroscopi[0,i]:=Round(CoeficientsDenFourier[2,i]*Escala);
    for i:=1 to BytesBuffer do LiniesOsciloscopi[0,i]:=so[NumeroBufer,i];
  end else if liniaProfe=1 then begin
    for i:=1 to NombreDEspectres do LiniesEspectroscopi[1,i]:=Round(CoeficientsDenFourier[2,i]*Escala);
    for i:=1 to BytesBuffer do LiniesOsciloscopi[1,i]:=so[NumeroBufer,i];
  end;
  if liniaProfe=0 then begin
    for i:=1 to NombreDEspectres do LiniesEnvolvent[0,i]:=Round(Envolvent[i]*Escala/40);
  end else if liniaProfe=1 then begin
    for i:=1 to NombreDEspectres do LiniesEnvolvent[1,i]:=Round(Envolvent[i]*Escala/40);
  end;
  if not CheckBoxOsciloscopi.Checked then begin
    Sota:=Height-80;
    inci:=10;
    i:=1;
    {Eix X}
    Canvas.Font.Color:=clBlack;
    Canvas.Pen.Color:=RGB(128,128,128);
    Canvas.MoveTo(0,Sota);
    Canvas.LineTo(ClientRect.Right,Sota);
    while round(i*inci)<ClientRect.Right do begin
      Canvas.MoveTo(round(i*inci),Sota-2);
      Canvas.LineTo(round(i*inci),Sota+2);
      inc(i);
    end;
    inci:=inci*10;
    i:=1;
    while round(i*inci)<ClientRect.Right do begin
      Canvas.MoveTo(round(i*inci),10);
      Canvas.LineTo(round(i*inci),Sota+5);
      str(i*UnitatEixX,StrFrec);
      Canvas.textOut(round(i*inci)-round(Canvas.TextWidth(StrFrec)/2),ClientRect.Bottom-28,StrFrec);
      inc(i);
    end;
    {Eix Y}
    i:=Sota;
    n:=0;
    if CheckBoxLiniesAlMateixLLoc.Checked then begin
      while i>10 do begin
        Canvas.MoveTo(0,i);
        Canvas.LineTo(ClientRect.Right,i);
        StrFrec:=RealToString(n/2*UnitatEixY);
        Canvas.TextOut(ClientRect.Right-2-canvas.TextWidth(StrFrec),i-8,StrFrec);
        i:=i-20;
        inc(n);
      end;
    end else begin
      while i>Sota-180 do begin
        Canvas.MoveTo(0,i);
        Canvas.LineTo(ClientRect.Right,i);
        StrFrec:=RealToString(n/2*UnitatEixY);
        Canvas.TextOut(ClientRect.Right-2-canvas.TextWidth(StrFrec),i-8,StrFrec);
        i:=i-20;
        inc(n);
      end;
      i:=Sota-200;
      n:=0;
      while i>10 do begin
        Canvas.MoveTo(0,i);
        Canvas.LineTo(ClientRect.Right,i);
        StrFrec:=RealToString(n/2*UnitatEixY);
        Canvas.TextOut(ClientRect.Right-2-canvas.TextWidth(StrFrec),i-8,StrFrec);
        i:=i-20;
        inc(n);
      end;
    end;
    Canvas.Pen.Color:=clBlack;
    //Canvas.MoveTo(0,Sota);
    if CheckBoxFFT.Checked then begin
      Canvas.MoveTo(round(CoeficientsDenFourier[1,1]/UnitatEixX*100),Sota-round(LiniesEspectroscopi[1,1]/UnitatEixY));
      for i:=2 to NombreDEspectres do Canvas.LineTo(round(CoeficientsDenFourier[1,i]/UnitatEixX*100),Sota-round(LiniesEspectroscopi[1,i]/UnitatEixY));
    end;
    if CheckBoxEnvolvent.Checked then begin
      Canvas.MoveTo(round(CoeficientsDenFourier[1,1]/UnitatEixX*100),Sota-round(LiniesEnvolvent[1,1]/UnitatEixY));
      for i:=2 to NombreDEspectres do Canvas.LineTo(round(CoeficientsDenFourier[1,i]/UnitatEixX*100),Sota-round(LiniesEnvolvent[1,i]/UnitatEixY));
    end;
    if not CheckBoxCalculAutomaticFrequencia.Checked then begin
      if not CheckBoxLiniesAlMateixLLoc.Checked then sota:=Sota-200;
    end;
    Canvas.Pen.Color:=clBlue;
    //Canvas.MoveTo(0,Sota);
    if CheckBoxFFT.Checked then begin
      Canvas.MoveTo(round(CoeficientsDenFourier[1,1]/UnitatEixX*100),Sota-round(LiniesEspectroscopi[0,1]/UnitatEixY));
      for i:=2 to NombreDEspectres do Canvas.LineTo(round(CoeficientsDenFourier[1,i]/UnitatEixX*100),Sota-round(LiniesEspectroscopi[0,i]/UnitatEixY));
    end;
    if CheckBoxEnvolvent.Checked then begin
      Canvas.MoveTo(round(CoeficientsDenFourier[1,1]/UnitatEixX*100),Sota-round(LiniesEnvolvent[0,1]/UnitatEixY));
      for i:=2 to NombreDEspectres do Canvas.LineTo(round(CoeficientsDenFourier[1,i]/UnitatEixX*100),Sota-round(LiniesEnvolvent[0,i]/UnitatEixY));
    end;
  end else begin
    Canvas.Pen.Color:=RGB(128,128,128);
    Sota:=Panel.Height+128;
    Canvas.MoveTo(0,Sota);
    Canvas.LineTo(ClientRect.Right,Sota);
    //14-02-03
    Canvas.Pen.Style:=psDot;
    i:=32;
    while i<=128 do begin
      Canvas.MoveTo(0,Sota-i);
      Canvas.LineTo(ClientRect.Right,Sota-i);
      Canvas.TextOut(0,Sota-i-8,FloatToStr(Round(20*ln((i)/(128))/ln(10)*10)/10));
      Canvas.MoveTo(0,Sota+i);
      Canvas.LineTo(ClientRect.Right,Sota+i);
      Canvas.TextOut(0,Sota+i-8,FloatToStr(Round(20*ln((i)/(128))/ln(10)*10)/10));
      i:=i+32;
    end;
    Canvas.Pen.Style:=psSolid;
    if not CheckBoxLiniesAlMateixLLoc.Checked then begin
      Canvas.MoveTo(0,Sota+256);
      Canvas.LineTo(ClientRect.Right,Sota+256);
      Canvas.Pen.Style:=psDot;
      i:=32;
      while i<=128 do begin
        Canvas.MoveTo(0,Sota+256-i);
        Canvas.LineTo(ClientRect.Right,Sota+256-i);
        Canvas.TextOut(0,Sota+256-i-8,FloatToStr(Round(20*ln((i)/(128))/ln(10)*10)/10));
        Canvas.MoveTo(0,Sota+256+i);
        Canvas.LineTo(ClientRect.Right,Sota+256+i);
        Canvas.TextOut(0,Sota+256+i-8,FloatToStr(Round(20*ln((i)/(128))/ln(10)*10)/10));
        i:=i+32;
      end;
      Canvas.Pen.Style:=psSolid;
    end;

    if CheckBoxCalculAutomaticFrequencia.Checked then begin
      ComensamentOsciloscopi[0]:=1;
      Comodi:=(UltimN div 2);
      Canvas.Pen.Color:=RGB(128,0,0);
      Canvas.MoveTo(0,Sota);
      for n:=1 to UltimN do begin
        SumaDesfase:=0;
        for k:=1 to UltimN do SumaDesfase:=SumaDesfase+abs(LiniesOsciloscopi[0,ComensamentOsciloscopi[0]+n+k]-LiniesOsciloscopi[0,ComensamentOsciloscopi[0]+k]);
        ValorsSumaDesfase[n]:=(SumaDesfase div Comodi);
        Canvas.LineTo(n,Sota-ValorsSumaDesfase[n]);
      end;
      i:=10;
      while (ValorsSumaDesfase[i]<ValorsSumaDesfase[i+1]) and (i<UltimN) do inc(i);
      if i<UltimN then begin
        Minim:=ValorsSumaDesfase[i];
        Maxim:=0;
        XMinim:=i;
        XMaxim:=i;
        for n:=i to UltimN do begin
          if ValorsSumaDesfase[n]>Maxim then begin
            Maxim:=ValorsSumaDesfase[n];
            XMaxim:=n;
          end;
          if ValorsSumaDesfase[n]<Minim then begin
            Minim:=ValorsSumaDesfase[n];
            XMinim:=n;
          end;
        end;
        if XMinim>10 then begin
          Canvas.Pen.Color:=RGB(128,128,0);
          Canvas.MoveTo(XMinim,Sota-128);
          Canvas.LineTo(XMinim,Sota+128);
        end;
        Canvas.Font.Color:=RGB(0,0,0);
        LabelFrequencia.Font.Color:=RGB(128,128,0);
        LabelTornatNota.Font.Color:=RGB(128,128,0);
        LabelFrequencia.Caption:=IntToStr(Round(Muestras/XMinim))+' Hz.';
        LabelTornatNota.Caption:=TornarNota(Muestras/XMinim);
      end;
      if XMinim>10 then begin
        XLiniaMax:=1;
        YLiniaMax:=LiniesOsciloscopi[0,ComensamentOsciloscopi[0]+1];
        for i:=1 to XMinim do begin
          if LiniesOsciloscopi[0,ComensamentOsciloscopi[0]+i]<YLiniaMax then begin
            XLiniaMax:=i;
            YLiniaMax:=LiniesOsciloscopi[0,ComensamentOsciloscopi[0]+i];
          end;
        end;
        ComensamentOsciloscopi[0]:=ComensamentOsciloscopi[0]+XLiniaMax;
      end;
    end;

    Canvas.Pen.Color:=clBlue;
    Canvas.MoveTo(0,LiniesOsciloscopi[0,ComensamentOsciloscopi[0]]+Panel.Height);
    For i:=ComensamentOsciloscopi[0]+1 to BytesBuffer do Canvas.LineTo(i-ComensamentOsciloscopi[0],LiniesOsciloscopi[0,i]+Panel.Height);
    Canvas.Pen.Color:=clBlack;
    if CheckBoxLiniesAlMateixLLoc.Checked then begin
      Canvas.MoveTo(0,LiniesOsciloscopi[1,ComensamentOsciloscopi[1]]+Panel.Height);
      For i:=ComensamentOsciloscopi[1]+1 to BytesBuffer do Canvas.LineTo(i-ComensamentOsciloscopi[1],LiniesOsciloscopi[1,i]+Panel.Height);
    end else begin
      Canvas.MoveTo(0,LiniesOsciloscopi[1,ComensamentOsciloscopi[1]]+256+Panel.Height);
      For i:=ComensamentOsciloscopi[1]+1 to BytesBuffer do Canvas.LineTo(i-ComensamentOsciloscopi[1],LiniesOsciloscopi[1,i]+256+Panel.Height);
    end;

  end;
end;

procedure TFormEspectroscopi.FormPaint(Sender: TObject);
begin
  Pintar;
end;

procedure TFormEspectroscopi.FormResize(Sender: TObject);
begin
  Repaint;
end;

procedure TFormEspectroscopi.SpeedButtonEngegarPararClick(Sender: TObject);
var
  i:integer;
begin
   if SpeedButtonEngegarParar.Down then begin
    if CheckBoxRapid.Checked then
     IniciarDadesUnitEntradaSo(512)
    else
     IniciarDadesUnitEntradaSo(1024);
    EngegarProcesEntradaSo(Handle);
    NombreDEspectres:=BytesBuffer div 2;
    SpeedButtonEngegarParar.Caption:='P';
    SpeedButtonEngegarPararGlobus.Enabled:=false;
    for i:=1 to BytesBufferMaxim do begin
      LiniesEspectroscopi[0,i]:=0;
      LiniesEspectroscopi[1,i]:=0;
      LiniesOsciloscopi[0,i]:=128;
      LiniesOsciloscopi[1,i]:=128;
      Envolvent[i]:=0;
      LiniesEnvolvent[0,i]:=0;
      LiniesEnvolvent[1,i]:=0;
    end;
    LiniaProfe:=0;
    ComensamentOsciloscopi[0]:=1;
    ComensamentOsciloscopi[1]:=1;
    CheckBoxMagic.Enabled:=true;
    CheckBoxRapid.Enabled:=false;
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    if not CheckBoxCalculAutomaticFrequencia.Checked then begin
      SpeedButtonEngegarPararGlobus.Enabled:=true;
    end;
    LiniaProfe:=-1;
    CheckBoxMagic.Enabled:=false;
    CheckBoxRapid.Enabled:=true;
    ComensamentOsciloscopi[0]:=1;
    ComensamentOsciloscopi[1]:=1;
  end;
end;

procedure TFormEspectroscopi.SpeedButtonEngegarPararGlobusClick(Sender: TObject);
var
  i:integer;
begin
  if SpeedButtonEngegarPararGlobus.Down then begin
    if CheckBoxRapid.Checked then
     IniciarDadesUnitEntradaSo(512)
    else
     IniciarDadesUnitEntradaSo(1024);
    EngegarProcesEntradaSo(Handle);
    NombreDEspectres:=BytesBuffer div 2;
    SpeedButtonEngegarPararGlobus.Caption:='P';
    SpeedButtonEngegarParar.Enabled:=false;
    for i:=1 to BytesBufferMaxim do begin
      LiniesEspectroscopi[1,i]:=0;
      LiniesOsciloscopi[1,i]:=128;
      LiniesEnvolvent[1,i]:=0;
    end;
    LiniaProfe:=1;
    ComensamentOsciloscopi[0]:=1;
    ComensamentOsciloscopi[1]:=1;
    CheckBoxMagic.Enabled:=true;
    CheckBoxRapid.Enabled:=false;
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarParar.Enabled:=true;
    LiniaProfe:=-1;
    ComensamentOsciloscopi[0]:=1;
    ComensamentOsciloscopi[1]:=1;
    CheckBoxMagic.Enabled:=false;
    CheckBoxRapid.Enabled:=true;
  end;
end;

procedure TFormEspectroscopi.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if SpeedButtonEngegarParar.Down or SpeedButtonEngegarPararGlobus.Down then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarPararGlobus.Down:=false;
    SpeedButtonEngegarPararGlobus.Enabled:=true;
  end;
end;

procedure TFormEspectroscopi.WMWIMDATA(var Msg: TMessage);
var
  i:integer;
begin
  For i:=1 to BytesBuffer do Envolvent[i]:=so[NumeroBufer,i]-127;
  if CheckBoxMagic.Checked then begin
    CalculPreemfasis(Envolvent,BytesBuffer);
    CalculFinestradeHamming(Envolvent,BytesBuffer);
  end;
  CalculQuoeficientsLPC(Envolvent,BytesBuffer,20);
  if CheckBoxMagic.Checked then for i:=1 to BytesBuffer do Envolvent[i]:=2*Envolvent[i];
  For i:=1 to BytesBuffer do CoeficientsDenFourier[2,i]:=so[NumeroBufer,i]-127;
  CalculFFT(BytesBuffer);
  Repaint;
  EntradaSo;
end;

procedure TFormEspectroscopi.EditUnitatXExit(Sender: TObject);
var
  c:integer;
  v: LongInt;
begin
  val(EditUnitatX.Text,v,c);
  if c=0 then begin
    if v>0 then begin
      UnitatEixX:=v;
    end else begin
      EditUnitatX.Text:='1000';
      UnitatEixX:=1000;
    end;
  end else begin
    EditUnitatX.Text:='1000';
    UnitatEixX:=1000;
  end;
  Repaint;
end;

procedure TFormEspectroscopi.EditUnitatYExit(Sender: TObject);
var
  c:integer;
  v:Single;
begin
  val(EditUnitatY.Text,v,c);
  if c=0 then begin
    if v>0 then begin
      UnitatEixY:=v;
    end else begin
      EditUnitatY.Text:='4';
      UnitatEixY:=4;
    end;
  end else begin
    EditUnitatY.Text:='4';
    UnitatEixY:=4;
  end;
  Repaint;
end;

procedure TFormEspectroscopi.CheckBoxLiniesAlMateixLLocClick(Sender: TObject);
begin
  if CheckBoxLiniesAlMateixLLoc.Checked then begin
    if not CheckBoxOsciloscopi.Checked then Height:=343 else ClientHeight:=Panel.Height+256+Panel1.Height;
  end else begin
    if not CheckBoxOsciloscopi.Checked then Height:=343+AlturaInicial else ClientHeight:=Panel.Height+512+Panel1.Height;
  end;
  Repaint;
end;

procedure TFormEspectroscopi.CheckBoxOsciloscopiClick(Sender: TObject);
begin
  if not CheckBoxCalculAutomaticFrequencia.Checked then begin
    if CheckBoxLiniesAlMateixLLoc.Checked then begin
      if not CheckBoxOsciloscopi.Checked then Height:=343 else ClientHeight:=Panel.Height+256+Panel1.Height;
    end else begin
      if not CheckBoxOsciloscopi.Checked then Height:=343+AlturaInicial else ClientHeight:=Panel.Height+512+Panel1.Height;
    end;
  end;
  if CheckBoxOsciloscopi.Checked then begin
    EditUnitatX.Enabled:=false;
    EditUnitatY.Enabled:=false;
    CheckBoxFFT.Enabled:=false;
    CheckBoxEnvolvent.Enabled:=false;
  end else begin
    EditUnitatX.Enabled:=true;
    EditUnitatY.Enabled:=true;
    CheckBoxFFT.Enabled:=true;
    CheckBoxEnvolvent.Enabled:=true;
  end;
  Repaint;
end;

procedure TFormEspectroscopi.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormEspectroscopi.FormMouseMove(Sender: TObject;Shift: TShiftState; X, Y: Integer);
begin
  if not CheckBoxOsciloscopi.Checked then begin
    LabelFrequencia.Font.Color:=clBlue;
    LabelTornatNota.Font.Color:=clBlue;
    LabelDecibels.Font.Color:=clBlue;
    LabelFrequencia.Caption:=IntToStr(Round(x/100*UnitatEixX))+' Hz.';
    LabelTornatNota.Caption:=TornarNota(x/100*UnitatEixX);
  end else begin
    if x>0 then begin
      if x<200 then UltimN:=X else UltimN:=200; 
      LabelFrequencia.Font.Color:=clBlue;
      LabelTornatNota.Font.Color:=clBlue;
      LabelDecibels.Font.Color:=clBlue;
      LabelFrequencia.Caption:=IntToStr(Round(Muestras/x))+' Hz.';
      LabelTornatNota.Caption:=TornarNota(Muestras/x);
      if (y<Panel.Height+256) then begin
        if x+ComensamentOsciloscopi[0]>0 then begin
          if abs(LiniesOsciloscopi[0,x+ComensamentOsciloscopi[0]]-128)>=1 then begin
            LabelDecibels.Caption:=FloatToStr(Round(10*ln(sqr(LiniesOsciloscopi[0,x+ComensamentOsciloscopi[0]]-128)/sqr(128))/ln(10)*100)/100)+' Db.';
          end else LabelDecibels.Caption:='';
        end else LabelDecibels.Caption:='';
      end else if y<Panel.Height+512 then begin
        if x+ComensamentOsciloscopi[1]>0 then begin
          if abs(LiniesOsciloscopi[1,x+ComensamentOsciloscopi[1]]-128)>=1 then begin
            LabelDecibels.Caption:=FloatToStr(Round(10*ln(sqr(LiniesOsciloscopi[1,x+ComensamentOsciloscopi[1]]-128)/sqr(128))/ln(10)*100)/100)+' Db.';
          end else LabelDecibels.Caption:='';
        end else LabelDecibels.Caption:='';
      end else LabelDecibels.Caption:='';
    end;
  end;
end;

procedure TFormEspectroscopi.FormMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
  end else begin
    if SpeedButtonEngegarParar.Down or SpeedButtonEngegarPararGlobus.Down then begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
      SpeedButtonEngegarParar.Enabled:=true;
      SpeedButtonEngegarPararGlobus.Caption:='EG';
      SpeedButtonEngegarPararGlobus.Down:=false;
      SpeedButtonEngegarPararGlobus.Enabled:=true;
    end;
  end;
  if CheckBoxCalculAutomaticFrequencia.Checked then exit;
  if SpeedButtonEngegarParar.Down or SpeedButtonEngegarPararGlobus.Down then exit;
  if CheckBoxOsciloscopi.Checked then begin
    if Button=mbLeft then begin
      if y<=Panel.Height+256 then begin
        ComensamentOsciloscopi[0]:=x+ComensamentOsciloscopi[0];
      end else begin
        ComensamentOsciloscopi[1]:=x+ComensamentOsciloscopi[1];
      end;
    end else begin
      ComensamentOsciloscopi[0]:=1;
      ComensamentOsciloscopi[1]:=1;
    end;
    Repaint;
  end;
end;

procedure TFormEspectroscopi.CheckBoxFFTClick(Sender: TObject);
begin
  Repaint;
end;

procedure TFormEspectroscopi.CheckBoxEnvolventClick(Sender: TObject);
begin
  Repaint;
end;

procedure TFormEspectroscopi.CheckBoxMagicClick(Sender: TObject);
{
var
  i:integer;
}
begin
  {
  For i:=1 to BytesBuffer do Envolvent[i]:=so[NumeroBufer,i]-127;
  if CheckBoxMagic.Checked then begin
    CalculPreemfasis(Envolvent,BytesBuffer);
    CalculFinestradeHamming(Envolvent,BytesBuffer);
  end;
  CalculQuoeficientsLPC(Envolvent,BytesBuffer,20);
  if CheckBoxMagic.Checked then for i:=1 to BytesBuffer do Envolvent[i]:=2*Envolvent[i];
  For i:=1 to BytesBuffer do CoeficientsDenFourier[2,i]:=so[NumeroBufer,i]-127;
  CalculFFT(BytesBuffer);
  Repaint;
  }
end;

procedure TFormEspectroscopi.CheckBoxCalculAutomaticFrequenciaClick(Sender: TObject);
begin
  if CheckBoxCalculAutomaticFrequencia.Checked then begin
    SpeedButtonEngegarPararGlobus.Enabled:=false;
    if not CheckBoxLiniesAlMateixLLoc.Checked then begin
      if not CheckBoxOsciloscopi.Checked then Height:=343 else ClientHeight:=Panel.Height+256+Panel1.Height;
    end;
    CheckBoxLiniesAlMateixLLoc.Enabled:=false;
  end else begin
    if not (SpeedButtonEngegarParar.Caption='P') then SpeedButtonEngegarPararGlobus.Enabled:=true;
    if not CheckBoxLiniesAlMateixLLoc.Checked then begin
      if not CheckBoxOsciloscopi.Checked then Height:=343+AlturaInicial else ClientHeight:=Panel.Height+512+Panel1.Height;
    end;
    CheckBoxLiniesAlMateixLLoc.Enabled:=true;
  end;
  Repaint
end;

procedure TFormEspectroscopi.IniciarCaptions;
begin
  if CheckBoxOsciloscopi.Checked then begin
    if XMinim>10 then begin
      LabelFrequencia.Font.Color:=RGB(128,128,0);
      LabelTornatNota.Font.Color:=RGB(128,128,0);
      LabelFrequencia.Caption:=IntToStr(Round(Muestras/XMinim))+' Hz.';
      LabelTornatNota.Caption:=TornarNota(Muestras/XMinim);
    end else begin
      LabelFrequencia.Caption:='';
      LabelTornatNota.Caption:='';
    end;
    if EnergiaOna<>0 then begin
      LabelDecibels.Font.Color:=RGB(128,128,0);
      LabelDecibels.Caption:=FloatToStr(Round(EnergiaOna*100/100))+' Db.';
    end else LabelDecibels.Caption:='';
  end else begin
    LabelFrequencia.Caption:='';
    LabelTornatNota.Caption:='';
    LabelDecibels.Caption:='';
  end;
  UltimN:=200;
end;

procedure TFormEspectroscopi.PanelMouseMove(Sender: TObject;Shift: TShiftState; X, Y: Integer);
begin
  IniciarCaptions;
end;

procedure TFormEspectroscopi.Panel1MouseMove(Sender: TObject;Shift: TShiftState; X, Y: Integer);
begin
  IniciarCaptions;
end;

procedure TFormEspectroscopi.FormMouseUp(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (SpeedButtonEngegarParar.Caption='P') and (Button=mbRight) then begin
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarPararClick(sender);
  end else if (SpeedButtonEngegarPararGlobus.Caption='P') and (Button=mbRight) then begin
    SpeedButtonEngegarPararGlobus.Down:=false;
    SpeedButtonEngegarPararGlobusClick(sender);
  end;
end;

procedure TFormEspectroscopi.CheckBoxRapidClick(Sender: TObject);
var
  i:integer;
begin
  for i:=1 to BytesBufferMaxim do begin
    LiniesEspectroscopi[0,i]:=0;
    LiniesEspectroscopi[1,i]:=0;
    LiniesOsciloscopi[0,i]:=128;
    LiniesOsciloscopi[1,i]:=128;
    Envolvent[i]:=0;
    LiniesEnvolvent[0,i]:=0;
    LiniesEnvolvent[1,i]:=0;
    CoeficientsDenFourier[1,i]:=0;
    CoeficientsDenFourier[2,i]:=0;
    so[NumeroBufer,i]:=128;
  end;
  LiniaProfe:=0;
  ComensamentOsciloscopi[0]:=1;
  ComensamentOsciloscopi[1]:=1;
  Repaint;
end;

end.
